VAQBUL03 ;ALB/JRP - BULLETINS;25-MAY-93
 ;;1.5;PATIENT DATA EXCHANGE;**9**;NOV 17, 1993
RESULTS(TRANPTR) ;SEND RESULTS RECEIVED BULLETIN
 ;INPUT  : TRANPTR - Pointer to VAQ - TRANSACTION file
 ;OUTPUT : 0 - Bulletin sent
 ;         -1^Error_Text - Bulletin not sent
 ;
 ;CHECK INPUT
 S TRANPTR=+$G(TRANPTR)
 Q:(('TRANPTR)!('$D(^VAT(394.61,TRANPTR)))) "-1^Did not pass valid transaction"
 ;DECLARE VARIABLES
 N TRANNUM,NAME,PID,DOB,RQSTBY,RQSTON,ATHRBY,SITE,DOMAIN
 N STATUS,TMP,TMPARR,LINE,OFFSET,SPACE,COMMENT,X,DIWL,DIWR,DIWF
 N SENSITVE,DFN,XMY,Y,TMPROOT,ERROR
 S TMPARR="^TMP(""VAQ-BUL"","_$J_")"
 K @TMPARR,^UTILITY($J,"W")
 S SPACE="  "
 ;DETERMINE RESULT OF REQUEST
 S TMP=$$STATYPE^VAQCON1(TRANPTR,1)
 Q:($P(TMP,"^",1)="-1") TMP
 Q:($P(TMP,"^",2)'="RES") "-1^Transaction did not contain results of a request"
 S STATUS=$P(TMP,"^",1)
 ;GET TRANSACTION NUMBER
 S TMP=$G(^VAT(394.61,TRANPTR,0))
 S TRANNUM=+TMP
 Q:('TRANNUM) "-1^Transaction did not contain a transaction number"
 ;GET PATIENT POINTER
 S DFN=+$P(TMP,"^",3)
 ;CHECK REMOTE SENSITIVITY (SET TO 1 IF SENSITIVE)
 S SENSITVE=+$P(TMP,"^",4)
 ;CHECK LOCAL SENSITIVITY (SET TO 2 IF SENSITIVE)
 I (('SENSITVE)&(DFN)) D
 .S SENSITVE=+$$GETSEN^VAQUTL97(DFN)
 .;ON ERROR ASSUME SENSITIVE
 .S:(SENSITVE) SENSITVE=2
 ;RETURN SUCCESS IF NOTIFICATION WAS NOT REQUESTED AND PATIENT
 ; IS NOT SENSITIVE AT LOCAL AND REMOTE FACILITY
 I ('(+$O(^VAT(394.61,TRANPTR,"NTFY2",0)))) Q:('SENSITVE) 0
 ;GET PATIENT INFORMATION
 S TMP=$G(^VAT(394.61,TRANPTR,"QRY"))
 S NAME=$P(TMP,"^",1)
 S:(NAME="") NAME="Not listed"
 S DOB=$$DOBFMT^VAQUTL99($P(TMP,"^",3),0)
 S:(DOB="") DOB="Not listed"
 S PID=$P(TMP,"^",4)
 I (PID="") D
 .;GET PID FROM SSN
 .S PID=$P(TMP,"^",2)
 .I (PID="") S PID="Not listed" Q
 .S PID=$$DASHSSN^VAQUTL99(PID)
 ;GET REQUEST INFORMATION
 S TMP=$G(^VAT(394.61,TRANPTR,"RQST1"))
 S RQSTON=$$DOBFMT^VAQUTL99($P(TMP,"^",1),1)
 S:(RQSTON="") RQSTON="Could not be determined"
 S RQSTBY=$P(TMP,"^",2)
 S:(RQSTBY="") RQSTBY="Unknown"
 ;GET REMOTE INFORMATION
 S TMP=$G(^VAT(394.61,TRANPTR,"ATHR1"))
 S ATHRBY=$P(TMP,"^",2)
 S:(ATHRBY="") ATHBY="Uknown"
 S:(ATHRBY="POSTMASTER") ATHBY="PDX Server"
 S TMP=$G(^VAT(394.61,TRANPTR,"ATHR2"))
 S SITE=$P(TMP,"^",1)
 S:(SITE="") SITE="Could not be determined"
 S DOMAIN=$P(TMP,"^",2)
 S:(DOMAIN="") DOMAIN="Could not be determined"
 ;BUILD MESSAGE
 S LINE=1
 S TMP="Your request for information has been "
 S TMP=TMP_$S((STATUS="VAQ-RSLT"):"processed and returned",1:"rejected")_" ..."
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=""
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 ;PUT IN TRANSACTION INFO
 S TMP=SPACE_"Transaction number: "_TRANNUM
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=SPACE_"Name: "_NAME
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=SPACE_"PID: "_PID
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=SPACE_"DOB: "_DOB
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=""
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 ;PRINT SENSITIVITY
 I (SENSITVE) D
 .S TMP="*** PATIENT WAS LISTED AS SENSITIVE AT THE REMOTE FACILITY ***"
 .S:(SENSITVE=2) TMP="*** PATIENT IS LISTED AS SENSITIVE IN YOUR FACILITY ***"
 .S TMP=SPACE_TMP
 .S @TMPARR@("DISPLAY",LINE,0)=TMP
 .S LINE=LINE+1
 .S TMP=""
 .S @TMPARR@("DISPLAY",LINE,0)=TMP
 .S LINE=LINE+1
 ;PUT IN REQUESTING INFO
 S TMP=SPACE_"Requested by: "_RQSTBY
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=SPACE_"Requested on: "_RQSTON
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=""
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 ;PUT IN AUTHORIZING INFO
 S TMP=SPACE_"Processed by: "_ATHRBY
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=SPACE_"Site: "_SITE
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=SPACE_"Domain: "_DOMAIN
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 S TMP=""
 S @TMPARR@("DISPLAY",LINE,0)=TMP
 S LINE=LINE+1
 ;CONTINUATION
 S ERROR=0
 D RESULTS^VAQBUL04
 ;DONE (CLEAN UP)
 K @TMPARR,^UTILITY($J,"W")
 Q ERROR
